
import { ArticleSearchPopup } from '../article/ArticleSearchPopup.js';



export class OfferEditWidget {
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/sales/offer/')}}" class="fa fa-chevron-circle-left"></a>
				<span ez-if="isNew == false">
					<a href="javascript:void(0);" [onclick]="widget.deleteOffer" class="fa fa-trash"></a>
					
					<a href="javascript:void(0);" [onclick]="widget.printOffer" class="fa fa-print"></a>
				</span>
				<a href="javascript:void(0);" [onclick]="widget.saveOffer" class="fa fa-save"></a>
			</div>
			<h1>{{isNew?'Nieuwe offerte':'Bewerk offerte'}}</h1>
		</div>
		
		
		<div class="action-box">
			<span ez-if="isNew == false"><a href="javascript:void(0);" [onclick]="widget.createOrder">{{_('Create order')}}</a></span>
			<span ez-if="isNew == false"><a href="javascript:void(0);" [onclick]="widget.createInvoice">{{_('Create invoice')}}</a></span>
		</div>
		
		
		<form id="frmOffer" action="{{appUrl('/service/sales/offer.do')}}">
			<input type="hidden" name="a" value="save" />
			
			<input type="hidden" name="offerId" value="{{o.offerId}}" />
			
			<ez-string hideempty="1" name="offerNumber" label="Offerte #" [value]="o.offerNumber"></ez-string>
			
			<ez-date name="offerDate" label="Datum" [value]="o.offerDate"></ez-date>
			
			<ez-table-selector name="customerId" 
						label="Klant" 
						url="{{appUrl('/service/customers.do?a=tableSearch')}}"
						[value]="o.customerId" 
						[valueText]="o.customerName"></ez-table-selector>

			
			<ez-select name="offerStatus" [value]="o.offerStatus" label="Status">
				<option value="open">Open</option>
				<option value="sent">Verstuurd</option>
				<option value="accepted">Akkoord</option>
				<option value="rejected">Niet akkoord</option>
				<option value="partial">Gedeeltelijk akkoord</option>
				<option value="cancelled">Geannuleerd</option>
			</ez-select>
			
			<ez-text name="subject" label="Betreft" [value]="o.subject"></ez-text>
			
			
			<div class="offer-list sales-table">
				<div class="header">
					<div class="col-sort"></div>
					<div class="col-description">Omschrijving</div>
					<div class="col-amount">Aantal</div>
					<div class="col-price">{{ _('amountLabel.'+salesSettings.inputPrice) }}</div>
					<div class="col-vat">Btw</div>
					<div class="col-total">Totaal</div>
				</div>
				<div class="sales-lines"></div>
				
				<div class="sales-totals">
					<div class="col-amount"></div>
					<div class="col-total"></div>
				</div>
			</div>
			
			<div class="action-box">
				<span><a href="javascript:void(0);" [onclick]="widget.addArticle">Artikel toevoegen</a></span>
				<span><a href="javascript:void(0);" [onclick]="widget.addLine">Prijsregel toevoegen</a></span>
				<span><a href="javascript:void(0);" [onclick]="widget.addTextLine">Tekstregel toevoegen</a></span>
			</div>
			
			
			<ez-textarea name="comment" label="Opmerking op offerte" [value]="o.comment"></ez-textarea>
			
			<ez-textarea name="internalNote" label="Interne opmerking" [value]="o.internalNote"></ez-textarea>
			
			
			<ez-datetime-text label="Bewerkt op" hideempty="1" [value]="o.edited"></ez-datetime-text>
			<ez-datetime-text label="Aangemaakt op" hideempty="1" [value]="o.created"></ez-datetime-text>
		</form>
	`;
	
	container = null;
	loading = false;
	
	ezTpl = null;
	offer = {
		offerNumber: '',
		customerId: 0,
		customerName: '',
		offerStatus: 'open',
		subject: '',
		comment: '',
		internalNote: '',
		offerDate: format_date(new Date())
	};
	
	orders = [];
	invoices = [];
		
	isNew = false;
	
	vats = null;
	salesSettings = null;
	
	lineNo = 0;
	
	changed = false;
	
	
	init(e) {
		this.container = e;
		
		let id = getUrlParam('id');
		
		postUrl('/service/sales/offer.do', {
			a: 'config'
		}).then( async function(e) {
			let json = await e.json();
			this.vats = json.vats;
			this.salesSettings = json.salesSettings;
			
			if (id) {
				this.loadOffer( id );
			}
			else {
				this.isNew = true;
				this.render();
			}
		}.bind(this) );
		
	}
	
	render() {
//		console.log( this.tpl );
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setVar('o', this.offer);
		this.ezTpl.setVar('isNew', this.isNew);
		this.ezTpl.setVar('salesSettings', this.salesSettings);
		
		this.ezTpl.setObject('widget', this);
		this.ezTpl.render();
		
		for(let i in this.offer.lines) {
			let l = this.offer.lines[i];
			console.log('createLine', l);
			
			if (this.salesSettings.inputPrice == 'incl_vat') {
				l.price = l.priceInclVat;
			}
			else {
				l.price = l.priceExclVat;
			}
			
			this.createLine(l);
		}
		
		$('.offer-list .sales-lines').sortable({
			handle: '.col-sort'
		});
		
		this.calculateTotals();
	}
	
	addLine() {
		console.log('addLine');
		
		this.createLine({
			lineType: 'price'
		});
		
	}
	
	addTextLine() {
		console.log('addLine');
		
		this.createLine({
			lineType: 'text'
		});
	}
	
	addArticle() {
		let p = new ArticleSearchPopup();
		
		
		p.setSelectArticle(function(article) {
			let price;
			if (this.salesSettings.inputPrice == 'incl_vat') {
				price = article.line_price_incl_vat;
			}
			else {
				price = article.line_price_excl_vat;
			}
			
			let pricetypeId = 0;
			if ( article.selectedSlotplan ) {
				pricetypeId = article.selectedSlotplan.slotplanPricetypeId;
			}
			
			this.createLine({
				lineType: 'article',
				articleId: article.articleId,
				pricetypeId: pricetypeId,
				shortDescription: article.line_description,
				price: price,
				amount: 1,
				vatId: article.vatId
			});
		}.bind(this));
		
		p.show();
	}
	
	createLine( opts ) {
		let ln = this.lineNo++;
		
		let c = $('<div />');
		c.addClass('sales-line');
		c.addClass('line-no-' + ln);
		c.data('line-no', ln);
		c.data('line-type', opts.lineType);
		
		let col_sort = $('<div class="col-sort"><span class="fa fa-bars sort-handle"></span></div>');
		
		if (opts.lineType == 'text') {
			c.addClass('sales-line-text');
			
			let col_desc1 = $('<div class="col-description1"></div>');
			let inp_desc1 = $('<input type="text" />');
			inp_desc1.attr('name', 'sl_description1_'+ln);
			inp_desc1.val( opts.shortDescription );
			col_desc1.append( inp_desc1 );
			
			let col_desc2 = $('<div class="col-description2"></div>');
			let inp_desc2 = $('<input type="text" />');
			inp_desc2.attr('name', 'sl_description2_'+ln);
			inp_desc2.val( opts.shortDescription2 );
			col_desc2.append( inp_desc2 );
			
			let col_del = $('<div class="col-delete-line"><a href="javascript:void(0);" class="fa fa-remove delete-line"></a></div>');
			
			c.append( col_sort );
			c.append( col_desc1 );
			c.append( col_desc2 );
			c.append( col_del );
		}
		
		if (opts.lineType == 'price') {
			c.addClass('sales-line-price');
			
			let col_desc = $('<div class="col-description"></div>');
			let inp_description = $('<input type="text" />');
			inp_description.attr('name', 'sl_description_'+ln);
			inp_description.val( opts.shortDescription );
			col_desc.append( inp_description );
			
			let col_amount = $('<div class="col-amount"></div>');
			let inp_amount = $('<input type="number" />');
			inp_amount.attr('name', 'sl_amount_'+ln);
			inp_amount.val( opts.amount );
			col_amount.append( inp_amount );
			
			let col_price = $('<div class="col-price"></div>');
			let inp_price = $('<input type="text" class="format-price" />');
			inp_price.attr('name', 'sl_price_'+ln);
			inp_price.val( opts.price );
			col_price.append( inp_price );
			
			
			let col_vat = $('<div class="col-vat"></div>');
			let inp_vat = this.buildVatSelect( opts.vatPercentage );
			inp_vat.attr('name', 'sl_vat_'+ln);
			col_vat.append( inp_vat );
			
			let col_total = $('<div class="col-total"></div>');
			
			let col_del = $('<div class="col-delete-line"><a href="javascript:void(0);" class="fa fa-remove delete-line"></a></div>');
			
			c.append( col_sort );
			c.append( col_desc );
			c.append( col_amount );
			c.append( col_price );
			c.append( col_vat );
			c.append( col_total );
			c.append( col_del );
		}
		
		if (opts.lineType == 'article') {
			c.addClass('sales-line-article');
			
			c.data('article-id', opts.articleId);
			c.data('pricetype-id', opts.pricetypeId);
			
			let col_desc = $('<div class="col-description"></div>');
			col_desc.text( opts.shortDescription );
			
			let col_amount = $('<div class="col-amount"></div>');
			let inp_amount = $('<input type="number" />');
			inp_amount.attr('name', 'sl_amount_'+ln);
			inp_amount.val(opts.amount);
			col_amount.append( inp_amount );
			
			let col_price = $('<div class="col-price"></div>');
			let inp_price = $('<input type="text" class="format-price" />');
			inp_price.attr('name', 'sl_price_'+ln);
			inp_price.val( opts.price );
			col_price.append( inp_price );
			
			
			let col_vat = $('<div class="col-vat"></div>');
			let inp_vat = this.buildVatSelect( opts.vatPercentage );
			inp_vat.attr('name', 'sl_vat_'+ln);
			col_vat.append( inp_vat );

			
			let col_total = $('<div class="col-total"></div>');
			let col_del = $('<div class="col-delete-line"><a href="javascript:void(0);" class="fa fa-remove delete-line"></a></div>');
			
			c.append( col_sort );
			c.append( col_desc );
			c.append( col_amount );
			c.append( col_price );
			c.append( col_vat );
			c.append( col_total );
			c.append( col_del );
		}
		
		c.data('line-type', opts.type);
		
		$(c).find('.delete-line').on('click', function(evt) {
			$(evt.target).closest('.sales-line').remove();
			this.calculateTotals();
		}.bind(this));
		
		$(c).find('input, select').on('change', function() {
			this.calculateTotals();
		}.bind(this));
		
		$('#frmOffer .sales-lines').append( c );
		
		this.calculateTotals();
	}
	
	buildVatSelect( vatPercentage ) {
		let selectedVatId = null;
		
		// lookup default vatId
		for(let i in this.vats) {
			if ( this.vats[i].defaultSelected ) {
				selectedVatId = this.vats[i].vatId;
				break;
			}
		}
		
		let addVatPercentage = false;
		if (typeof vatPercentage != 'undefined') {
			addVatPercentage = true;
			
			let p = parseInt(vatPercentage * 100);
			for(let i in this.vats) {
				if ( parseInt(this.vats[i].percentage * 100) == p  ) {
					selectedVatId = this.vats[i].vatId;
					addVatPercentage = false;
					break;
				}
			}
		}
		
		let inp_vat = $('<select  />');
		for(let i in this.vats) {
			let opt = $('<option />');
			opt.data('vat', this.vats[i]);
			opt.data('vatPercentage', this.vats[i].percentage);
			opt.val( this.vats[i].vatId );
			opt.text( this.vats[i].description );
			if (this.vats[i].vatId == selectedVatId)
				opt.prop('selected', true);
			inp_vat.append( opt );
		}
		
		// old percentage thats not in system anymore? => add
		if (addVatPercentage) {
			let opt = $('<option />');
			opt.data('vatPercentage', vatPercentage);
			opt.val( -1 );
			opt.text( vatPercentage + '%' );
			opt.prop('selected', true);
			inp_vat.append( opt );
		}
		
		
		return inp_vat;
	}
	
	
	
	saveOffer() {
		if (this.loading) {
			return;
		}
		
		this.loading = true;
		
		let frm = $('#frmOffer');
		
		let data = {};
		data.offerId      = frm.find('input[name=offerId]').val();
		data.offerDate    = frm.find('input[name=offerDate]').val();
		data.customerId   = frm.find('input[name=customerId]').val();
		data.offerStatus  = frm.find('select[name=offerStatus]').val();
		data.subject      = frm.find('input[name=subject]').val();
		data.comment      = frm.find('textarea[name=comment]').val();
		data.internalNote = frm.find('textarea[name=internalNote]').val();
		data.lines = [];
		
		let lines = frm.find('.offer-list .sales-lines .sales-line');
		
		for(let i=0; i < lines.length; i++) {
			let line = $(lines.get(i));
			
			let l = {};
			l.lineType = line.data('line-type');
			
			if (l.lineType == 'text') {
				l.shortDescription = line.find('.col-description1 input').val();
				l.shortDescription2 = line.find('.col-description2 input').val();
			}
			if (l.lineType == 'price') {
				l.shortDescription = line.find('.col-description input').val();
				l.amount = strtodouble( line.find('.col-amount input').val() );
				l.price = strtodouble( line.find('.col-price input').val() );
				l.vatPercentage = line.find('.col-vat select option:selected').data('vatPercentage');
			}
			if (l.lineType == 'article') {
				l.articleId = line.data('article-id');
				l.pricetypeId = line.data('pricetype-id');
				l.shortDescription = $.trim( line.find('.col-description').text() );
				l.amount = strtodouble( line.find('.col-amount input').val() );
				l.price = strtodouble( line.find('.col-price input').val() );
				l.vatPercentage = line.find('.col-vat select option:selected').data('vatPercentage');
			}
			
			data.lines.push( l );
			
		}
		
		console.log( data );
		
		data.a = 'save';
		
		showLoadingForm('#frmOffer');
		return postJson('/service/sales/offer.do', data )
			.then( async function(e) {
				let json = await e.json();
				
				if (json.success) {
					reportUserMessage( 'Wijzigingen opgeslagen' );
					gotoRoute( '/sales/offer/edit/?id='+json.offerId );
				}
				else {
					formShowErrors('#frmOffer', json);
				}
				
				this.loading = false;
				hideLoadingForm('#frmOffer');
			}.bind(this) );
	}
	
	deleteOffer() {
		showConfirmation('Verwijderen', 'Weet je zeker dat je deze offerte wilt verwijderen?', function() {
			
			postUrl( '/service/sales/offer.do', {
				a: 'delete',
				offerId: this.offer.offerId
			}).then( async function(e) {
				let json = await e.json();
				if (json.error) {
					showAlert('Error', 'Error: ' + json.message);
					return;
				}
				
				gotoRoute( '/sales/offer/' );
			}.bind(this) );
			
		}.bind(this));
	}
	
	printOffer() {
		
		if (toolboxConfig.desktopMode) {
			postUrl( '/service/sales/offer.do', {
				a: 'openOffer',
				id: this.offer.offerId
			});
		}
		else {
			window.open( appUrl('/service/sales/offer.do?a=print&id='+this.offer.offerId), '_blank' );
		}
		
		
	}
	
	
	
	loadOffer(offerId) {
		postUrl( '/service/sales/offer.do'
			, {
					a: 'view',
					offerId: offerId
			}).then( async function(e) {
				let json = await e.json();
				if (json.error) {
					return showErrorWidget(json);
				}
				
				this.offer = json.offer;
				this.orders = json.orders;
				this.invoices = json.invoices;
				this.render();
				
				this.loading = false;
			}.bind(this) );
	}
	
	
	
	createOrder() {
		let msg = '';
		if (this.orders.length > 0) {
			msg = _('Are you sure to generate an order AGAIN? Previous orders: ');
			
			let orderNumbers = [];
			for(let i=0; i < this.orders.length; i++) {
				orderNumbers.push( this.orders[i].orderNumber );
			}
			
			msg += orderNumbers.join(' & ');
		}
		else {
			msg = _('Are you sure to generate an order?');
		}
		
		
		showConfirmation(_('Create order'), msg, () => {
			postJson( '/service/sales/offer.do', {
				a: 'createOrder',
				offerId: this.offer.offerId
			} ).then( async (e) => {
				let json = await e.json();
				
				reportUserMessage( _('Order created') );
				
				gotoRoute( '/sales/order/edit/?id=' + json.orderId );
			});
		});
		
	}
	
	createInvoice() {
		let msg = '';
		if (this.invoices.length > 0) {
			msg = _('Are you sure to generate an invoice AGAIN? Previous invoice(s): ');
			
			let invoiceNumbers = [];
			for(let i=0; i < this.invoices.length; i++) {
				invoiceNumbers.push( this.invoices[i].invoiceNumber );
			}
			
			msg += invoiceNumbers.join(' & ');
		}
		else {
			msg = _('Are you sure to generate an invoice?');
		}


		showConfirmation(_('Create invoice'), msg, () => {
			postJson( '/service/sales/offer.do', {
				a: 'createInvoice',
				offerId: this.offer.offerId
			} ).then( async (e) => {
				let json = await e.json();
				
				reportUserMessage( _('Invoice created') );
				
				gotoRoute( '/sales/invoice/edit/?id=' + json.invoiceId );
			});
		});
	}
	
	
	
	calculateTotals() {
		
		let totalAmount = 0;
		let totalExclVat = 0;
		let totalInclVat = 0;
		let totalVat = {
		};
		
		$('.sales-table .sales-line').each(function(index, node) {
			// skip text lines
			if ($(node).data('line-type') == 'text')
				return;
			
			let amount = strtodouble( $(node).find('.col-amount input').val() );
			let price = strtodouble( $(node).find('.col-price input').val() );
			let optVat = $(node).find('.col-vat select option:selected');
			let vatPercentage = optVat.data('vatPercentage');
			
			
			if (isNaN(amount) || isNaN(price))
				return;
			
			
			let vatPercentageInt = parseInt(vatPercentage*100);
			
			let vatAmount = 0;
			let total = 0;
			
			
			totalAmount += amount;
			
			if ( this.salesSettings.inputPrice == 'excl_vat' ) {
				vatAmount = calculateVatExclPrice(price, vatPercentage);
				
				total = roundNumber( (price+vatAmount) * amount, 2 );
				
				totalExclVat += roundNumber( price * amount, 2 );
				totalInclVat += total;
			}
			else if ( this.salesSettings.inputPrice == 'incl_vat' ) {
				vatAmount = calculateVatInclPrice(price, vatPercentage);
				
				let priceExclVat = roundNumber( price - vatAmount, 2 );
				
				total = roundNumber( price * amount, 2 );
				
				totalExclVat += roundNumber( priceExclVat * amount, 2 );
				totalInclVat += total;
			}
			
			if (typeof totalVat[vatPercentageInt] == 'undefined') {
				totalVat[vatPercentageInt] = {
					amount: 0,
					percentage: vatPercentage
				};
			}
			
			totalVat[vatPercentageInt]['amount'] += ( vatAmount * amount );
			
			$(node).find('.col-total').text( format_price(total, true) );
		}.bind(this));
		
		
		$('.sales-table .sales-totals .col-amount').text(totalAmount);
		
		let t = $('.sales-table .sales-totals .col-total');
		t.empty();
		t.append('<div>Prijs excl. btw ' + format_price(totalExclVat, true) + '</div>');
		for(let p in totalVat) {
			t.append('<div>Btw ' + totalVat[p].percentage + '% ' + format_price(totalVat[p].amount, true) + '</div>');
		}
		
		t.append('<div>Prijs incl. btw ' + format_price(totalInclVat, true) + '</div>');
		
	}
	
	
}


